
// BITax.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.

/*!
    @class       BITax
    @abstract    BITax represents an individual tax, ie. GST.
    @discussion  Stores all of the important information pertaining to a tax, tax name, tax percent, tax reg number, etc.
*/


#ifdef BILLINGS_PRO
#import "_BPTax.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BITax.h"
#endif
#import "BIAppVersioning.h"


@interface BITax : BL_SUPER_CLASSNAME_MUNGE(Tax) 
{
}

- (void)setInitialValues;
- (void)setInitialValuesWithObjectContext:(id)oc;

- (NSDictionary*)archiveWithDictionary;
- (void)unarchiveFromDictionary:(NSDictionary*)aDict;

- (NSArray*)activeConsolidatedTaxes;
- (NSArray*)activeNotAtomicConsolidatedTaxes;

- (BOOL)detailsMoreCompleteThanTax:(BITax*)aTax;

- (BOOL)isCompound;
- (void)setIsCompound:(BOOL)aFlag;

- (NSString*)nameWithRate;

- (NSArray*)parentTaxes;
- (NSArray*)addParentTaxToArray:(NSMutableArray*)taxesArray;

- (NSString*)isCompoundString;
- (void)isCompoundString:(NSString*)aString;

- (NSNumberFormatter *)currencyFormatter;

/*
 Exporting code uses the name of the tax as a keyPath that is retrieved by an implementation of -valueForUndefinedKey:
 The name can't have any periods in them, or they'll be interpereted as defining a keyPath by KVC
 */
- (NSString*)nameAsKeyPath;

@end
